﻿var fieldOptions = {
    context: $(".v-fieldOptions"),
    questionnaireId: $("#QuestionnaireId").val(),
    initialize: function () {
        $(".h-trackResponseModificationsQuestionsAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetVariablesForAutoComplete", "Home"),
            ajaxParams: { questionnaireId: fieldOptions.questionnaireId },
            valueProperty: "Name",
            labelProperty: "Alias",
            altValueField: $("#TrackResponseModificationsQuestions", fieldOptions.context),
            multipleSelection: true,
            hideSelectedItems: true,
            displayMultipleSelectionAsList: true
        });

        $(".h-includeInCallHistoryAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetVariablesForAutoComplete", "Home"),
            ajaxParams: { questionnaireId: fieldOptions.questionnaireId },
            valueProperty: "Name",
            labelProperty: "Alias",
            altValueField: $("#IncludeInCallHistory", fieldOptions.context),
            multipleSelection: true,
            hideSelectedItems: true,
            displayMultipleSelectionAsList: true
        });

        $(".h-piiVariablesMultiselect", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetVariablesForAutoComplete", "Home"),
            ajaxParams: { questionnaireId: fieldOptions.questionnaireId },
            valueProperty: "Name",
            labelProperty: "Alias",
            altValueField: $("#PIIVariables", fieldOptions.context),
            multipleSelection: true,
            hideSelectedItems: true,
            displayMultipleSelectionAsList: true
        });

        $(".h-reassignCodesAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetInterruptionCodesForAutoComplete", "Home"),
            ajaxParams: { questionnaireId: fieldOptions.questionnaireId },
            valueProperty: "Name",
            labelProperty: "Alias",
            altValueField: $("#ReassignCodes", fieldOptions.context),
            multipleSelection: true,
            hideSelectedItems: true,
            displayMultipleSelectionAsList: true
        });

        a4.initializeInputs(fieldOptions.context);
    },
    bindEvents: function () {
        this.context.on("change", "#TrackResponseModifications :radio", function () {
            $(".h-trackResponseModificationsQuestionsAutoComplete", this.context).a4autocomplete("toggle", $(this).val() != "Selected");
        });

        this.context.on("change", "#DoNotCallList", function () {
            var expirationInput = $(".v-doNotCallListExpirationSection input", this.context);
            if ($(this).val() != "EnforceWithExpiration") {
                expirationInput.val('0');
                expirationInput.prop('readonly', true);
            }
            else
                expirationInput.prop('readonly', false);
        });

        this.context.on("click", ".h-copyFieldOptions", function () {
            a4.showSelectProjectDialog(function (sourceProjectId) {
                a4.callServerMethod(a4.getProjectAction("GetFieldOptions", "Settings"), { sourceProjectId: sourceProjectId },
                function (result) {
                    $(".v-fieldOptionsContent", fieldOptions.context).html(result);
                    fieldOptions.initialize();

                    $("form.validate-save").a4unsavedChanges("change");

                    if ($("#CopiedAllQuestions", fieldOptions.context).val().toLowerCase() == "false")
                        a4.showErrorMessage(resources.NotAllQuestionsWereCopied);
                });
            }, resources.CopyFieldOptionsTitle);
        });

        projectMenu.onBeforeRefresh = function () {
            window.location.reload();
        };
    }
}

$(document).ready(function () {
    if (fieldOptions.context.length > 0) {
        fieldOptions.initialize();
        fieldOptions.bindEvents();
    }
});